/*
 * Decompiled with CFR 0.152.
 */
package inetsoft.spark.quickbooks.source;

import inetsoft.spark.quickbooks.QuickbooksDataSourceOptions;
import inetsoft.spark.quickbooks.SparkSchema;
import inetsoft.spark.quickbooks.source.QuickbooksPartitionReader;
import inetsoft.spark.quickbooks.source.QuickbooksStreamReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class QuickbooksTable
implements Table,
SupportsRead,
Serializable {
    private final QuickbooksStreamReader reader;
    private final QuickbooksDataSourceOptions quickbooksOptions;
    private SparkSchema schema = null;

    public QuickbooksTable(QuickbooksDataSourceOptions options, QuickbooksStreamReader reader) {
        this.quickbooksOptions = options;
        this.reader = reader;
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        return () -> new QuickbooksInputScan();
    }

    public String name() {
        return this.quickbooksOptions.getCompanyId() + ":" + this.quickbooksOptions.getEntity();
    }

    public StructType schema() {
        if (this.schema == null) {
            this.schema = this.reader.getSchema();
        }
        return this.schema.getStructType();
    }

    public Set<TableCapability> capabilities() {
        return Collections.singleton(TableCapability.BATCH_READ);
    }

    public static class Partition
    implements InputPartition,
    Serializable {
    }

    public class QuickbooksInputScan
    implements Scan,
    Batch,
    Serializable {
        public Batch toBatch() {
            return this;
        }

        public StructType readSchema() {
            if (QuickbooksTable.this.schema == null) {
                QuickbooksTable.this.schema = QuickbooksTable.this.reader.getSchema();
            }
            return QuickbooksTable.this.schema.getStructType();
        }

        public InputPartition[] planInputPartitions() {
            return new InputPartition[]{new Partition(){}};
        }

        public PartitionReaderFactory createReaderFactory() {
            return (PartitionReaderFactory & Serializable)partition -> new QuickbooksPartitionReader(QuickbooksTable.this.reader, QuickbooksTable.this.schema);
        }
    }
}

