///* Copyright © INFINI Ltd. All rights reserved.
// * Web: https://infinilabs.com
// * Email: hello#infini.ltd */
//
//package org.easysearch.client;
//
//import org.apache.http.client.methods.HttpDelete;
//import org.apache.http.client.methods.HttpGet;
//import org.apache.http.client.methods.HttpPost;
//import org.apache.http.client.methods.HttpPut;
//import org.easysearch.client.ccr.CcrStatsRequest;
//import org.easysearch.client.ccr.DeleteAutoFollowPatternRequest;
//import org.easysearch.client.ccr.FollowInfoRequest;
//import org.easysearch.client.ccr.FollowStatsRequest;
//import org.easysearch.client.ccr.ForgetFollowerRequest;
//import org.easysearch.client.ccr.GetAutoFollowPatternRequest;
//import org.easysearch.client.ccr.PauseAutoFollowPatternRequest;
//import org.easysearch.client.ccr.PauseFollowRequest;
//import org.easysearch.client.ccr.PutAutoFollowPatternRequest;
//import org.easysearch.client.ccr.PutFollowRequest;
//import org.easysearch.client.ccr.ResumeAutoFollowPatternRequest;
//import org.easysearch.client.ccr.ResumeFollowRequest;
//import org.easysearch.client.ccr.UnfollowRequest;
//
//import java.io.IOException;
//
//import static org.easysearch.client.RequestConverters.REQUEST_BODY_CONTENT_TYPE;
//import static org.easysearch.client.RequestConverters.createEntity;
//
//final class CcrRequestConverters {
//
//    static Request putFollow(PutFollowRequest putFollowRequest) throws IOException {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(putFollowRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "follow")
//            .build();
//        Request request = new Request(HttpPut.METHOD_NAME, endpoint);
//        RequestConverters.Params parameters = new RequestConverters.Params();
//        parameters.withWaitForActiveShards(putFollowRequest.waitForActiveShards());
//        request.setEntity(createEntity(putFollowRequest, REQUEST_BODY_CONTENT_TYPE));
//        request.addParameters(parameters.asMap());
//        return request;
//    }
//
//    static Request pauseFollow(PauseFollowRequest pauseFollowRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(pauseFollowRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "pause_follow")
//            .build();
//        return new Request(HttpPost.METHOD_NAME, endpoint);
//    }
//
//    static Request resumeFollow(ResumeFollowRequest resumeFollowRequest) throws IOException {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(resumeFollowRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "resume_follow")
//            .build();
//        Request request = new Request(HttpPost.METHOD_NAME, endpoint);
//        request.setEntity(createEntity(resumeFollowRequest, REQUEST_BODY_CONTENT_TYPE));
//        return request;
//    }
//
//    static Request unfollow(UnfollowRequest unfollowRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(unfollowRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "unfollow")
//            .build();
//        return new Request(HttpPost.METHOD_NAME, endpoint);
//    }
//
//    static Request forgetFollower(final ForgetFollowerRequest forgetFollowerRequest) throws IOException {
//        final String endpoint = new RequestConverters.EndpointBuilder()
//                .addPathPart(forgetFollowerRequest.leaderIndex())
//                .addPathPartAsIs("_ccr")
//                .addPathPartAsIs("forget_follower")
//                .build();
//        final Request request = new Request(HttpPost.METHOD_NAME, endpoint);
//        request.setEntity(createEntity(forgetFollowerRequest, REQUEST_BODY_CONTENT_TYPE));
//        return request;
//    }
//
//    static Request putAutoFollowPattern(PutAutoFollowPatternRequest putAutoFollowPatternRequest) throws IOException {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "auto_follow")
//            .addPathPart(putAutoFollowPatternRequest.getName())
//            .build();
//        Request request = new Request(HttpPut.METHOD_NAME, endpoint);
//        request.setEntity(createEntity(putAutoFollowPatternRequest, REQUEST_BODY_CONTENT_TYPE));
//        return request;
//    }
//
//    static Request deleteAutoFollowPattern(DeleteAutoFollowPatternRequest deleteAutoFollowPatternRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "auto_follow")
//            .addPathPart(deleteAutoFollowPatternRequest.getName())
//            .build();
//        return new Request(HttpDelete.METHOD_NAME, endpoint);
//    }
//
//    static Request getAutoFollowPattern(GetAutoFollowPatternRequest getAutoFollowPatternRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "auto_follow")
//            .addPathPart(getAutoFollowPatternRequest.getName())
//            .build();
//        return new Request(HttpGet.METHOD_NAME, endpoint);
//    }
//
//    static Request pauseAutoFollowPattern(PauseAutoFollowPatternRequest pauseAutoFollowPatternRequest) throws IOException {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "auto_follow")
//            .addPathPart(pauseAutoFollowPatternRequest.getName())
//            .addPathPartAsIs("pause")
//            .build();
//        return new Request(HttpPost.METHOD_NAME, endpoint);
//    }
//
//    static Request resumeAutoFollowPattern(ResumeAutoFollowPatternRequest resumeAutoFollowPatternRequest) throws IOException {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "auto_follow")
//            .addPathPart(resumeAutoFollowPatternRequest.getName())
//            .addPathPartAsIs("resume")
//            .build();
//        return new Request(HttpPost.METHOD_NAME, endpoint);
//    }
//
//    static Request getCcrStats(CcrStatsRequest ccrStatsRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPartAsIs("_ccr", "stats")
//            .build();
//        return new Request(HttpGet.METHOD_NAME, endpoint);
//    }
//
//    static Request getFollowStats(FollowStatsRequest followStatsRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(followStatsRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "stats")
//            .build();
//        return new Request(HttpGet.METHOD_NAME, endpoint);
//    }
//
//    static Request getFollowInfo(FollowInfoRequest followInfoRequest) {
//        String endpoint = new RequestConverters.EndpointBuilder()
//            .addPathPart(followInfoRequest.getFollowerIndex())
//            .addPathPartAsIs("_ccr", "info")
//            .build();
//        return new Request(HttpGet.METHOD_NAME, endpoint);
//    }
//
//}
