/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client;

import java.util.Optional;

/**
 * Defines a validation layer for Requests.
 */
public interface Validatable {

    Validatable EMPTY = new Validatable() {};

    /**
     * Perform validation. This method does not have to be overridden in the event that no validation needs to be done,
     * or the validation was done during object construction time. A {@link ValidationException} that is not null is
     * assumed to contain validation errors and will be thrown.
     *
     * @return An {@link Optional} {@link ValidationException} that contains a list of validation errors.
     */
    default Optional<ValidationException> validate() {
        return Optional.empty();
    }
}
