/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */


package org.easysearch.client.asyncsearch;

import org.easysearch.client.Validatable;

import java.util.Objects;

public class DeleteAsyncSearchRequest implements Validatable {

    private final String id;

    public DeleteAsyncSearchRequest(String id) {
        this.id = id;
}

    public String getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteAsyncSearchRequest request = (DeleteAsyncSearchRequest) o;
        return Objects.equals(getId(), request.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
