/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.cluster;

import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import static org.easysearch.common.xcontent.XContentParserUtils.ensureExpectedToken;

/**
 * A response to _remote/info API request.
 */
public final class RemoteInfoResponse {

    private List<RemoteConnectionInfo> infos;

    RemoteInfoResponse(List<RemoteConnectionInfo> infos) {
        this.infos = Collections.unmodifiableList(infos);
    }

    public List<RemoteConnectionInfo> getInfos() {
        return infos;
    }

    public static RemoteInfoResponse fromXContent(XContentParser parser) throws IOException {
        ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);

        List<RemoteConnectionInfo> infos = new ArrayList<>();

        XContentParser.Token token;
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String clusterAlias = parser.currentName();
            RemoteConnectionInfo info = RemoteConnectionInfo.fromXContent(parser, clusterAlias);
            infos.add(info);
        }
        ensureExpectedToken(XContentParser.Token.END_OBJECT, token, parser);
        return new RemoteInfoResponse(infos);
    }
}
