/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.core;

import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Map;

public final class GetSourceResponse {

    private final Map<String, Object> source;

    public GetSourceResponse(Map<String, Object> source) {
        this.source = source;
    }

    public static GetSourceResponse fromXContent(XContentParser parser) throws IOException {
        return new GetSourceResponse(parser.map());
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    @Override
    public String toString() {
        return source.toString();
    }
}
