/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.core;

import org.easysearch.client.Validatable;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import static org.easysearch.client.core.TermVectorsRequest.createFromTemplate;

public class MultiTermVectorsRequest implements ToXContentObject, Validatable {

    private List<TermVectorsRequest> requests = new ArrayList<>();

    /**
     * Constructs an empty MultiTermVectorsRequest
     * After that use {@code add} method to add individual {@code TermVectorsRequest} to it.
     */
    public MultiTermVectorsRequest() {}

    /**
     * Constructs a MultiTermVectorsRequest from the given document ids
     * and a template {@code TermVectorsRequest}.
     * Used when individual requests share the same index, type and other settings.
     * @param ids - ids of documents for which term vectors are requested
     * @param template - a template {@code TermVectorsRequest} that allows to set all
     * settings only once for all requests.
     */
    public MultiTermVectorsRequest(String[] ids, TermVectorsRequest template) {
        for (String id : ids) {
            TermVectorsRequest request = createFromTemplate(template, id);
            requests.add(request);
        }
    }

    /**
     * Adds another {@code TermVectorsRequest} to this {@code MultiTermVectorsRequest}
     * @param request - {@code TermVectorsRequest} to add
     */
    public void add(TermVectorsRequest request) {
        requests.add(request);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        builder.startArray("docs");
        for (TermVectorsRequest request : requests) {
            request.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

}
