/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.core;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;

import static org.easysearch.common.xcontent.ConstructingObjectParser.constructorArg;

public class ShardsAcknowledgedResponse extends AcknowledgedResponse {

    protected static final String SHARDS_PARSE_FIELD_NAME = "shards_acknowledged";
    private static ConstructingObjectParser<ShardsAcknowledgedResponse, Void> buildParser() {

        ConstructingObjectParser<ShardsAcknowledgedResponse, Void> p = new ConstructingObjectParser<>("freeze", true,
            args -> new ShardsAcknowledgedResponse((boolean) args[0], (boolean) args[1]));
        p.declareBoolean(constructorArg(), new ParseField(AcknowledgedResponse.PARSE_FIELD_NAME));
        p.declareBoolean(constructorArg(), new ParseField(SHARDS_PARSE_FIELD_NAME));
        return p;
    }

    private static final ConstructingObjectParser<ShardsAcknowledgedResponse, Void> PARSER = buildParser();

    private final boolean shardsAcknowledged;

    public ShardsAcknowledgedResponse(boolean acknowledged, boolean shardsAcknowledged) {
        super(acknowledged);
        this.shardsAcknowledged = shardsAcknowledged;
    }

    public boolean isShardsAcknowledged() {
        return shardsAcknowledged;
    }

    public static ShardsAcknowledgedResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }
}
