/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indexlifecycle;

import org.easysearch.client.TimedRequest;
import org.easysearch.common.Strings;

import java.util.Objects;

public class DeleteLifecyclePolicyRequest extends TimedRequest {

    private final String lifecyclePolicy;

    public DeleteLifecyclePolicyRequest(String lifecyclePolicy) {
        if (Strings.isNullOrEmpty(lifecyclePolicy)) {
            throw new IllegalArgumentException("lifecycle name must be present");
        }
        this.lifecyclePolicy = lifecyclePolicy;
    }

    public String getLifecyclePolicy() {
        return lifecyclePolicy;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DeleteLifecyclePolicyRequest that = (DeleteLifecyclePolicyRequest) o;
        return Objects.equals(getLifecyclePolicy(), that.getLifecyclePolicy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getLifecyclePolicy());
    }
}
