/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indexlifecycle;

import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.TimedRequest;
import org.easysearch.client.ValidationException;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * The request object used by the Explain Lifecycle API.
 */
public class ExplainLifecycleRequest extends TimedRequest {

    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    public ExplainLifecycleRequest(String... indices) {
        if (indices.length == 0) {
            throw new IllegalArgumentException("Must at least specify one index to explain");
        }
        this.indices = indices;
    }

    public String[] getIndices() {
        return indices;
    }

    public ExplainLifecycleRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public IndicesOptions indicesOptions() {
        return indicesOptions;
    }

    @Override
    public Optional<ValidationException> validate() {
        return Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(indices), indicesOptions);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != getClass()) {
            return false;
        }
        ExplainLifecycleRequest other = (ExplainLifecycleRequest) obj;
        return Objects.deepEquals(getIndices(), other.getIndices()) &&
                Objects.equals(indicesOptions(), other.indicesOptions());
    }

    @Override
    public String toString() {
        return "ExplainLifecycleRequest [indices()=" + Arrays.toString(indices) + ", indicesOptions()=" + indicesOptions + "]";
    }

}
