/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */


package org.easysearch.client.indexlifecycle;

import org.easysearch.client.TimedRequest;
import org.easysearch.common.Strings;

import java.util.Arrays;

public class GetLifecyclePolicyRequest extends TimedRequest {

    private final String[] policyNames;

    public GetLifecyclePolicyRequest(String... policyNames) {
        if (policyNames == null) {
            this.policyNames = Strings.EMPTY_ARRAY;
        } else {
            for (String name : policyNames) {
                if (name == null) {
                    throw new IllegalArgumentException("cannot include null policy name");
                }
            }
            this.policyNames = policyNames;
        }
    }

    public String[] getPolicyNames() {
        return policyNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetLifecyclePolicyRequest request = (GetLifecyclePolicyRequest) o;
        return Arrays.equals(getPolicyNames(), request.getPolicyNames());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(getPolicyNames());
    }
}
