/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indexlifecycle;

import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.NamedXContentRegistry;
import org.easysearch.plugins.spi.NamedXContentProvider;

import java.util.Arrays;
import java.util.List;

public class IndexLifecycleNamedXContentProvider implements NamedXContentProvider {


    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContentParsers() {
        return Arrays.asList(
            // ILM
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(AllocateAction.NAME),
                AllocateAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(DeleteAction.NAME),
                DeleteAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(ForceMergeAction.NAME),
                ForceMergeAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(ReadOnlyAction.NAME),
                ReadOnlyAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(RolloverAction.NAME),
                RolloverAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(ShrinkAction.NAME),
                ShrinkAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(WaitForSnapshotAction.NAME),
                WaitForSnapshotAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(FreezeAction.NAME),
                FreezeAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(SetPriorityAction.NAME),
                SetPriorityAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(MigrateAction.NAME),
                MigrateAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(SearchableSnapshotAction.NAME),
                SearchableSnapshotAction::parse),
            new NamedXContentRegistry.Entry(LifecycleAction.class,
                new ParseField(UnfollowAction.NAME),
                UnfollowAction::parse)
        );
    }
}
