/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indexlifecycle;

import org.easysearch.client.TimedRequest;
import org.easysearch.common.Strings;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

public class PutLifecyclePolicyRequest extends TimedRequest implements ToXContentObject {

    private final LifecyclePolicy policy;

    public PutLifecyclePolicyRequest(LifecyclePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy definition cannot be null");
        }
        if (Strings.isNullOrEmpty(policy.getName())) {
            throw new IllegalArgumentException("policy name must be present");
        }
        this.policy = policy;
    }

    public String getName() {
        return policy.getName();
    }

    public LifecyclePolicy getLifecyclePolicy() {
        return policy;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        builder.field("policy", policy);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PutLifecyclePolicyRequest that = (PutLifecyclePolicyRequest) o;
        return Objects.equals(getLifecyclePolicy(), that.getLifecyclePolicy());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getLifecyclePolicy());
    }
}
