/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indexlifecycle;

import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.TimedRequest;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class RemoveIndexLifecyclePolicyRequest extends TimedRequest {

    private final List<String> indices;
    private final IndicesOptions indicesOptions;

    public RemoveIndexLifecyclePolicyRequest(List<String> indices) {
        this(indices, IndicesOptions.strictExpandOpen());
    }

    public RemoveIndexLifecyclePolicyRequest(List<String> indices, IndicesOptions indicesOptions) {
        this.indices = Collections.unmodifiableList(Objects.requireNonNull(indices));
        this.indicesOptions = Objects.requireNonNull(indicesOptions);
    }

    public List<String> indices() {
        return indices;
    }

    public IndicesOptions indicesOptions() {
        return indicesOptions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(indices, indicesOptions);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        RemoveIndexLifecyclePolicyRequest other = (RemoveIndexLifecyclePolicyRequest) obj;
        return Objects.deepEquals(indices, other.indices) &&
                Objects.equals(indicesOptions, other.indicesOptions);
    }
}
