/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indices;

import org.easysearch.common.Strings;

/**
 * A request to check for the existence of component templates
 */
public class ComponentTemplatesExistRequest extends GetComponentTemplatesRequest {

    /**
     * Create a request to check for the existence of component template. Name must be provided
     *
     * @param name the name of template to check for the existence of
     */
    public ComponentTemplatesExistRequest(String name) {
        super(name);
        if (Strings.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("must provide component template name");
        }
    }
}
