/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.indices;

import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.TimedRequest;
import org.easysearch.common.Strings;

public class GetMappingsRequest extends TimedRequest {

    private boolean local = false;
    private boolean includeDefaults = false;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    /**
     * Indicates whether the receiving node should operate based on local index information or
     * forward requests, where needed, to other nodes. If running locally, request will not
     * raise errors if local index information is missing.
     */
    public GetMappingsRequest local(boolean local) {
        this.local = local;
        return this;
    }

    public boolean local() {
        return local;
    }

    public GetMappingsRequest indices(String... indices) {
        this.indices = indices;
        return this;
    }

    public GetMappingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] indices() {
        return indices;
    }

    public IndicesOptions indicesOptions() {
        return indicesOptions;
    }

    public boolean includeDefaults() {
        return includeDefaults;
    }

    /** Indicates whether default mapping settings should be returned */
    public GetMappingsRequest includeDefaults(boolean includeDefaults) {
        this.includeDefaults = includeDefaults;
        return this;
    }
}
