/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.indices;

import org.easysearch.action.support.IndicesOptions;
import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * Request for the _reload_search_analyzers API
 */
public final class ReloadAnalyzersRequest implements Validatable {

    private final String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    /**
     * Creates a new reload analyzers request
     * @param indices the index for which to reload analyzers
     */
    public ReloadAnalyzersRequest(String... indices) {
        this.indices = Objects.requireNonNull(indices);
    }

    /**
     * Returns the indices
     */
    public String[] getIndices() {
        return indices;
    }

    /**
     * Specifies what type of requested indices to ignore and how to deal with wildcard expressions.
     * For example indices that don't exist.
     *
     * @return the current behaviour when it comes to index names and wildcard indices expressions
     */
    public IndicesOptions indicesOptions() {
        return indicesOptions;
    }

    /**
     * Specifies what type of requested indices to ignore and how to deal with wildcard expressions.
     * For example indices that don't exist.
     *
     * @param indicesOptions the desired behaviour regarding indices to ignore and wildcard indices expressions
     */
    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }
}
