/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.rollup;

import org.easysearch.client.Validatable;
import org.easysearch.common.ParseField;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Objects;


public class DeleteRollupJobRequest implements Validatable, ToXContentObject {

    private static final ParseField ID_FIELD = new ParseField("id");
    private final String id;


    public DeleteRollupJobRequest(String id) {
        this.id = Objects.requireNonNull(id, "id parameter must not be null");
    }

    public String getId() {
        return id;
    }

    private static final ConstructingObjectParser<DeleteRollupJobRequest, Void> PARSER =
        new ConstructingObjectParser<>("request",  a -> {
            return new DeleteRollupJobRequest((String) a[0]);
        });

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID_FIELD);
    }

    public static DeleteRollupJobRequest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        builder.field(ID_FIELD.getPreferredName(), this.id);
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DeleteRollupJobRequest that = (DeleteRollupJobRequest) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
