/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.rollup;

import org.easysearch.client.Validatable;
import org.easysearch.cluster.metadata.Metadata;
import org.easysearch.common.Strings;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

public class GetRollupCapsRequest implements Validatable, ToXContentObject {
    private static final String ID = "id";
    private final String indexPattern;

    public GetRollupCapsRequest(final String indexPattern) {
        if (Strings.isNullOrEmpty(indexPattern) || indexPattern.equals("*")) {
            this.indexPattern = Metadata.ALL;
        } else {
            this.indexPattern = indexPattern;
        }
    }

    public String getIndexPattern() {
        return indexPattern;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        builder.field(ID, indexPattern);
        builder.endObject();
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(indexPattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        GetRollupCapsRequest other = (GetRollupCapsRequest) obj;
        return Objects.equals(indexPattern, other.indexPattern);
    }
}
