/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.rollup;

import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GetRollupCapsResponse {

    private final Map<String, RollableIndexCaps> jobs;

    public GetRollupCapsResponse(final Map<String, RollableIndexCaps> jobs) {
        this.jobs = Collections.unmodifiableMap(Objects.requireNonNull(jobs));
    }

    public Map<String, RollableIndexCaps> getJobs() {
        return jobs;
    }

    public static GetRollupCapsResponse fromXContent(final XContentParser parser) throws IOException {
        Map<String, RollableIndexCaps> jobs = new HashMap<>();
        XContentParser.Token token = parser.nextToken();
        if (token.equals(XContentParser.Token.START_OBJECT)) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token.equals(XContentParser.Token.FIELD_NAME)) {
                    String pattern = parser.currentName();

                    RollableIndexCaps cap = RollableIndexCaps.PARSER.parse(parser, pattern);
                    jobs.put(pattern, cap);
                }
            }
        }
        return new GetRollupCapsResponse(jobs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jobs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        GetRollupCapsResponse other = (GetRollupCapsResponse) obj;
        return Objects.equals(jobs, other.jobs);
    }
}
