/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.rollup;

import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;

import java.util.Objects;
import java.util.Optional;

/**
 * Request to fetch rollup jobs.
 */
public class GetRollupJobRequest implements Validatable {
    private final String jobId;

    /**
     * Create a requets .
     * @param jobId id of the job to return or {@code _all} to return all jobs
     */
    public GetRollupJobRequest(final String jobId) {
        Objects.requireNonNull(jobId, "jobId is required");
        if ("_all".equals(jobId)) {
            throw new IllegalArgumentException("use the default ctor to ask for all jobs");
        }
        this.jobId = jobId;
    }

    /**
     * Create a request to load all rollup jobs.
     */
    public GetRollupJobRequest() {
        this.jobId = "_all";
    }

    /**
     * ID of the job to return.
     */
    public String getJobId() {
        return jobId;
    }

    @Override
    public Optional<ValidationException> validate() {
        return Optional.empty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final GetRollupJobRequest that = (GetRollupJobRequest) o;
        return jobId.equals(that.jobId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jobId);
    }
}
