/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.rollup;

import org.easysearch.client.Validatable;
import org.easysearch.client.ValidationException;
import org.easysearch.client.rollup.job.config.RollupJobConfig;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class PutRollupJobRequest implements Validatable, ToXContentObject {

    private final RollupJobConfig config;

    public PutRollupJobRequest(final RollupJobConfig config) {
        this.config = Objects.requireNonNull(config, "rollup job configuration is required");
    }

    public RollupJobConfig getConfig() {
        return config;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        return config.toXContent(builder, params);
    }

    @Override
    public Optional<ValidationException> validate() {
        return config.validate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final PutRollupJobRequest that = (PutRollupJobRequest) o;
        return Objects.equals(config, that.config);
    }

    @Override
    public int hashCode() {
        return Objects.hash(config);
    }
}
