/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.rollup;

import org.easysearch.client.Validatable;

import java.util.Objects;

public class StartRollupJobRequest implements Validatable {

    private final String jobId;

    public StartRollupJobRequest(final String jobId) {
        this.jobId = Objects.requireNonNull(jobId, "id parameter must not be null");
    }

    public String getJobId() {
        return jobId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        final StartRollupJobRequest that = (StartRollupJobRequest) o;
        return Objects.equals(jobId, that.jobId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jobId);
    }
}
