/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.rollup;

import org.easysearch.client.core.AcknowledgedResponse;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;

public class StartRollupJobResponse extends AcknowledgedResponse {

    private static final String PARSE_FIELD_NAME = "started";

    private static final ConstructingObjectParser<StartRollupJobResponse, Void> PARSER = AcknowledgedResponse
            .generateParser("start_rollup_job_response", StartRollupJobResponse::new, PARSE_FIELD_NAME);

    public StartRollupJobResponse(boolean acknowledged) {
        super(acknowledged);
    }

    public static StartRollupJobResponse fromXContent(final XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    protected String getFieldName() {
        return PARSE_FIELD_NAME;
    }
}
