/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.rollup;

import org.easysearch.client.core.AcknowledgedResponse;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;

public class StopRollupJobResponse extends AcknowledgedResponse {

    private static final String PARSE_FIELD_NAME = "stopped";

    private static final ConstructingObjectParser<StopRollupJobResponse, Void> PARSER = AcknowledgedResponse
            .generateParser("stop_rollup_job_response", StopRollupJobResponse::new, PARSE_FIELD_NAME);

    public StopRollupJobResponse(boolean acknowledged) {
        super(acknowledged);
    }

    public static StopRollupJobResponse fromXContent(final XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    @Override
    protected String getFieldName() {
        return PARSE_FIELD_NAME;
    }
}
