/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.apache.http.client.methods.HttpGet;
import org.easysearch.client.Request;
import org.easysearch.client.Validatable;

/**
 * Empty request object required to make the authenticate call. The authenticate call
 * retrieves metadata about the authenticated user.
 */
public final class AuthenticateRequest implements Validatable {

    public static final AuthenticateRequest INSTANCE = new AuthenticateRequest();

    private AuthenticateRequest() {
    }

    public Request getRequest() {
        return new Request(HttpGet.METHOD_NAME, "/_security/_authenticate");
    }

}
