/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.CharArrays;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Arrays;

/**
 * Changes the password for the current user.
 */
public final class ChangePasswordRequest implements Validatable, ToXContentObject {

    private final  char[] password;
    private final  char[] currentPassword;


    public ChangePasswordRequest(char[] password, char[] currentPassword) {
        this.password = password;
        this.currentPassword = currentPassword;
    }

    public char[] getPassword() {
        return password;
    }

    public char[] getCurrentPassword() {
        return currentPassword;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        byte[] charBytes =  CharArrays.toUtf8Bytes(password);
        byte[] currentPasswordBytes =  CharArrays.toUtf8Bytes(currentPassword);
        try {
            return builder.startObject()
                .field("password").utf8Value(charBytes, 0, charBytes.length)
                .field("current_password").utf8Value(currentPasswordBytes, 0, currentPasswordBytes.length)
                .endObject();
        } finally {
            Arrays.fill(charBytes, (byte) 0);
            Arrays.fill(currentPasswordBytes, (byte) 0);
        }
    }
}
