/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.NodesResponseHeader;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.List;

/**
 * Response for a clear realm cache request. The response includes a header that contains the
 * number of successful and failed nodes.
 */
public final class ClearRealmCacheResponse extends SecurityNodesResponse {

    @SuppressWarnings("unchecked")
    public static final ConstructingObjectParser<ClearRealmCacheResponse, Void> PARSER =
        new ConstructingObjectParser<>("clear_realm_cache_response_parser",
            args -> new ClearRealmCacheResponse((List<Node>) args[0], (NodesResponseHeader) args[1], (String) args[2]));

    static {
        SecurityNodesResponse.declareCommonNodesResponseParsing(PARSER);
    }

    public ClearRealmCacheResponse(List<Node> nodes, NodesResponseHeader header, String clusterName) {
        super(nodes, header, clusterName);
    }

    public static ClearRealmCacheResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }
}
