/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;

/**
 * A request to delete privilege
 */
public final class DeletePrivilegesRequest implements Validatable {

    private final String privilege;

    /**
     * @param privilege the privilege to delete
     */
    public DeletePrivilegesRequest(String privilege) {
        this.privilege = privilege;
    }

    public String getPrivilege() {
        return privilege;
    }

}
