/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.Nullable;
import org.easysearch.common.Strings;

import java.util.Objects;

/**
 * Request object to delete a role mapping.
 */
public final class DeleteRoleMappingRequest implements Validatable {
    private final String name;

    /**
     * Constructor for DeleteRoleMappingRequest
     *
     * @param name          role mapping name to be deleted
     */
    public DeleteRoleMappingRequest(final String name) {
        if (Strings.hasText(name) == false) {
            throw new IllegalArgumentException("role name is required");
        }
        this.name = name;
    }

    public String getName() {
        return name;
    }

    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DeleteRoleMappingRequest other = (DeleteRoleMappingRequest) obj;

        return Objects.equals(name, other.name);
    }

}
