/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * A request delete a role.
 */
public final class DeleteRoleRequest implements Validatable {

    private final String name;

    public DeleteRoleRequest(String name) {
        this.name = Objects.requireNonNull(name, "name is required");
    }

    public String getName() {
        return name;
    }

}
