/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * A request to delete a user from the native realm.
 */
public final class DeleteUserRequest implements Validatable {

    private final String name;

    public DeleteUserRequest(String name) {
        this.name = Objects.requireNonNull(name, "user name is required");
    }

    public String getName() {
        return name;
    }


    @Override
    public int hashCode() {
        return Objects.hash(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final DeleteUserRequest other = (DeleteUserRequest) obj;

        return Objects.equals(name, other.name);
    }
}
