/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.easysearch.common.ParseField;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;

import static org.easysearch.common.xcontent.ConstructingObjectParser.constructorArg;

/**
 * Response for a user being deleted from the native realm
 */
public final class DeleteUserResponse {

    private final String status;
    private final String message;

    public DeleteUserResponse(String status, String message) {
        this.status = status;
        this.message = message;
    }

    private static final ConstructingObjectParser<DeleteUserResponse, Void> PARSER = new ConstructingObjectParser<>("delete_user_response",
        true, args -> new DeleteUserResponse((String) args[0], (String) args[1]));

    static {
        PARSER.declareString(constructorArg(), new ParseField("status"));
        PARSER.declareString(constructorArg(), new ParseField("message"));
    }


    public static DeleteUserResponse fromXContent(final XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @JsonIgnore
    public boolean isDelete() {
        return status.equals("OK");
    }

    public String toJson() {
        return JsonUtils.writeObjectAsString(this);
    }

}
