/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.security.user.Account;
import org.easysearch.client.security.user.User;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Return current user information.
 */
public class GetAccountResponse {
    private final Account account;

    public GetAccountResponse(Account account) {
        this.account = account;
    }

    public Account getAccount() {
        return account;
    }

    public static GetAccountResponse fromXContent(XContentParser parser) throws IOException {
        Account account = new Account();
        XContentParser.Token token;
        String currentFieldName = null;

        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
            }

            if (token.isValue()) {
                switch (currentFieldName) {
                    case "username":
                        account.setUsername(parser.text());
                        break;
                    case "reserved":
                        account.setReserved(parser.booleanValue());
                        break;
                    case "hidden":
                        account.setHidden(parser.booleanValue());
                        break;
                    case "builtin":
                        account.setBuiltin(parser.booleanValue());
                        break;
                    default:
                        break;
                }
            } else if (token == XContentParser.Token.START_ARRAY) {
                switch (currentFieldName) {
                    case "external_roles":
                        List<String> externalRoles = new ArrayList<>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            externalRoles.add(parser.text());
                        }
                        account.setExternalRoles(externalRoles);
                        break;
                    case "roles":
                        List<String> roles = new ArrayList<>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            roles.add(parser.text());
                        }
                        account.setRoles(roles);
                        break;
                    case "attributes":
                        Set<String> attributes = new HashSet<>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            attributes.add(parser.text());
                        }
                        account.setAttributes(attributes);
                        break;
                    default:
                        break;
                }
            }
        }

        return new GetAccountResponse(account);
    }


    public String toJson() {
        return JsonUtils.writeObjectAsString(account);
    }
}
