/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.apache.http.client.methods.HttpGet;
import org.easysearch.client.Request;
import org.easysearch.client.Validatable;

/**
 * Request object to retrieve the privilege that are builtin to the Easysearch cluster.
 */
public final class GetBuiltinPrivilegesRequest implements Validatable {

    public static final GetBuiltinPrivilegesRequest INSTANCE = new GetBuiltinPrivilegesRequest();

    private GetBuiltinPrivilegesRequest() {
    }

    public Request getRequest() {
        return new Request(HttpGet.METHOD_NAME, "/_security/privilege/_builtin");
    }

}
