/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.Nullable;
import org.easysearch.common.util.set.Sets;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Request object to get privilege(s)
 */
public final class GetPrivilegesRequest implements Validatable {
    private final Set<String> privilegeNames;

    public GetPrivilegesRequest(@Nullable final String... privilegeNames) {
        if (privilegeNames != null) {
            this.privilegeNames = Collections.unmodifiableSet(Sets.newHashSet(privilegeNames));
        } else {
            this.privilegeNames = Collections.emptySet();
        }
    }

    /**
     * @return an array of privilege names to return or null if all should be returned
     */
    public Set<String> getPrivilegeNames() {
        return privilegeNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetPrivilegesRequest that = (GetPrivilegesRequest) o;
        return Objects.equals(privilegeNames, that.privilegeNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(privilegeNames);
    }
}
