/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.easysearch.client.security.user.privileges.Privilege;
import org.easysearch.client.security.user.parser.PrivilegeJsonParser;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Get privileges response
 */
public final class GetPrivilegesResponse {

    private Set<Privilege> privileges;

    public Set<Privilege> getPrivileges() {
        return privileges;
    }

    public GetPrivilegesResponse(Set<Privilege> privileges) {
        this.privileges = Collections.unmodifiableSet(privileges);
    }

    public static GetPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        Set<Privilege> privileges =  PrivilegeJsonParser.parsePrivileges(parser);
        return new GetPrivilegesResponse(privileges);
    }

    public String toJson() {
        ObjectNode rootNode = JsonUtils.objectMapper.createObjectNode();
        for (Privilege p : this.privileges) {
            JsonNode roleNode = JsonUtils.objectMapper.valueToTree(p);
            rootNode.set(p.getName(), roleNode);
        }
        return JsonUtils.writeObjectAsString(rootNode);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GetPrivilegesResponse that = (GetPrivilegesResponse) o;
        return Objects.equals(privileges, that.privileges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(privileges);
    }
}
