/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.util.set.Sets;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Request object to get role mappings
 */
public final class GetRoleMappingsRequest implements Validatable {
    private final Set<String> roleMappingNames;

    public GetRoleMappingsRequest(final String... roleMappingNames) {
        if (roleMappingNames != null) {
           this.roleMappingNames = Collections.unmodifiableSet(Sets.newHashSet(roleMappingNames));
        } else {
           this.roleMappingNames = Collections.emptySet();
        }
    }

    public Set<String> getRoleMappingNames() {
        return roleMappingNames;
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleMappingNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final GetRoleMappingsRequest other = (GetRoleMappingsRequest) obj;

        return Objects.equals(roleMappingNames, other.roleMappingNames);
    }

}
