/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.easysearch.client.security.user.RoleMapping;
import org.easysearch.client.security.user.parser.RoleMappingJsonParser;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Set;

/**
 * Get role mappings response
 */
public final class GetRoleMappingsResponse {

    private final Set<RoleMapping> roleMappings;


    public GetRoleMappingsResponse(Set<RoleMapping> roleMappings) {
        this.roleMappings = roleMappings;
    }

    public Set<RoleMapping> getRoleMappings() {
        return roleMappings;
    }

    public static GetRoleMappingsResponse fromXContent(XContentParser parser) throws IOException {
        Set<RoleMapping> roleMappings = RoleMappingJsonParser.parseRoleMappings(parser);
        return new GetRoleMappingsResponse(roleMappings);
    }

    public String toJson() {
        ObjectNode rootNode = JsonUtils.objectMapper.createObjectNode();
        for (RoleMapping roleMapping : this.roleMappings) {
            JsonNode roleNode = JsonUtils.objectMapper.valueToTree(roleMapping);
            rootNode.set(roleMapping.getName(), roleNode);
        }
        return JsonUtils.writeObjectAsString(rootNode);
    }
}
