/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.util.set.Sets;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Request object to retrieve roles from the native roles store
 */
public final class GetRolesRequest implements Validatable {

    private final Set<String> roleNames;

    public GetRolesRequest(final String... roleNames) {
        if (roleNames != null) {
            this.roleNames = Collections.unmodifiableSet(Sets.newHashSet(roleNames));
        } else {
            this.roleNames = Collections.emptySet();
        }
    }

    public Set<String> getRoleNames() {
        return roleNames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final GetRolesRequest that = (GetRolesRequest) o;
        return Objects.equals(roleNames, that.roleNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleNames);
    }
}
