/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.apache.http.client.methods.HttpGet;
import org.easysearch.client.Request;
import org.easysearch.client.Validatable;

/**
 * Request object to retrieve the X.509 certificates that are used to encrypt communications in an Easysearch cluster.
 */
public final class GetSslCertificatesRequest implements Validatable {

    public static final GetSslCertificatesRequest INSTANCE = new GetSslCertificatesRequest();

    private GetSslCertificatesRequest() {
    }

    public Request getRequest() {
        return new Request(HttpGet.METHOD_NAME, "/_ssl/certificates");
    }

}
