/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.common.util.set.Sets;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Request object to retrieve users from the native realm
 */
public class GetUsersRequest implements Validatable {
    private final Set<String> usernames;

    public GetUsersRequest(final String... usernames) {
        if (usernames != null) {
            this.usernames = Collections.unmodifiableSet(Sets.newHashSet(usernames));
        } else {
            this.usernames = Collections.emptySet();
        }
    }

    public Set<String> getUsernames() {
        return usernames;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GetUsersRequest)) return false;
        GetUsersRequest that = (GetUsersRequest) o;
        return Objects.equals(usernames, that.usernames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(usernames);
    }
}
