/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */
package org.easysearch.client.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.easysearch.client.security.user.User;
import org.easysearch.client.security.user.parser.UserJsonParser;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * Response when requesting zero or more users.
 * Returns a List of {@link User} objects
 */
public class GetUsersResponse {
    private final Set<User> users;

    public GetUsersResponse(Set<User> users) {
        this.users = Collections.unmodifiableSet(users);
    }

    public Set<User> getUsers() {
        return users;
    }

    public static GetUsersResponse fromXContent(XContentParser parser) throws IOException {
        Set<User> users = UserJsonParser.parseUsers(parser);

        return new GetUsersResponse(users);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof GetUsersResponse)) return false;
        GetUsersResponse that = (GetUsersResponse) o;
        return Objects.equals(users, that.users);
    }

    @Override
    public int hashCode() {
        return Objects.hash(users);
    }

    public String toJson() {
        ObjectNode rootNode = JsonUtils.objectMapper.createObjectNode();
        for (User user : this.users) {
            JsonNode roleNode = JsonUtils.objectMapper.valueToTree(user);
            rootNode.set(user.getName(), roleNode);
        }
        return JsonUtils.writeObjectAsString(rootNode);
    }
}
