/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.client.security.user.privileges.Privilege;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

/**
 * Request object for creating/updating privileges.
 */
public final class PutPrivilegeRequest implements Validatable, ToXContentObject {

    private final Privilege privilege;

    public PutPrivilegeRequest(final Privilege privilege) {
        this.privilege = Objects.requireNonNull(privilege);
    }

    public Privilege getPrivilege() {
        return privilege;
    }

    @Override
    public int hashCode() {
        return Objects.hash(privilege);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || (this.getClass() != o.getClass())) {
            return false;
        }
        final PutPrivilegeRequest that = (PutPrivilegeRequest) o;
        return privilege.equals(that.privilege);
    }

    @Override
    public XContentBuilder toXContent(final XContentBuilder builder, final Params params) throws IOException {
        builder.startObject();
        builder.field("privileges", privilege.getPrivileges());
        return builder.endObject();
    }

}
