/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.client.security.user.RoleMapping;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

/**
 * Request object to create or update a role mapping.
 */
public final class PutRoleMappingRequest implements Validatable, ToXContentObject {

    private final RoleMapping roleMapping;

    public PutRoleMappingRequest(RoleMapping roleMapping) {
        this.roleMapping = roleMapping;
    }

    public RoleMapping getRoleMapping() {
        return roleMapping;
    }

    @Override
    public int hashCode() {
        return Objects.hash(roleMapping);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PutRoleMappingRequest other = (PutRoleMappingRequest) obj;

        return Objects.equals(roleMapping, other.roleMapping);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        builder.field("external_roles", roleMapping.getExternal_roles());
        builder.field("and_external_roles", roleMapping.getAnd_external_roles());
        builder.field("hosts", roleMapping.getHosts());
        builder.field("users", roleMapping.getUsers());
        builder.field("description", roleMapping.getDescription());
        return builder.endObject();
    }
}
