/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;
import org.easysearch.client.security.user.Role;
import org.easysearch.common.xcontent.ToXContentObject;
import org.easysearch.common.xcontent.XContentBuilder;

import java.io.IOException;
import java.util.Objects;

/**
 * Request object to create or update a role.
 */
public final class PutRoleRequest implements Validatable, ToXContentObject {

    private final Role role;

    public PutRoleRequest(Role role) {
        this.role = Objects.requireNonNull(role);
    }

    public Role getRole() {
        return role;
    }


    @Override
    public int hashCode() {
        return Objects.hash(role);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final PutRoleRequest other = (PutRoleRequest) obj;

        return Objects.equals(role, other.role);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, Params params) throws IOException {
        builder.startObject();
        if (role.getCluster() != null) {
            builder.field("cluster", role.getCluster());
        }
        if (role.getIndices() != null) {
            builder.field("indices", role.getIndices());
        }
        if (role.getDescription() != null) {
            builder.field("description", role.getDescription());
        }
        return builder.endObject();
    }

}
