/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.easysearch.common.ParseField;
import org.easysearch.common.util.JsonUtils;
import org.easysearch.common.xcontent.ConstructingObjectParser;
import org.easysearch.common.xcontent.XContentParser;

import java.io.IOException;

import static org.easysearch.common.xcontent.ConstructingObjectParser.constructorArg;

/**
 * Response when adding a role to the native roles store.
 */
public final class PutRoleResponse {

    private final String status;
    private final String message;

    public PutRoleResponse(String status, String message) {
        this.status = status;
        this.message = message;
    }

    private static final ConstructingObjectParser<PutRoleResponse, Void> PARSER = new ConstructingObjectParser<>("put_role_response",
        true, args -> new PutRoleResponse((String) args[0], (String) args[1]));

    static {
        PARSER.declareString(constructorArg(), new ParseField("status"));
        PARSER.declareString(constructorArg(), new ParseField("message"));
    }

    public static PutRoleResponse fromXContent(XContentParser parser) throws IOException {

        return PARSER.parse(parser, null);
    }

    public String getStatus() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    @JsonIgnore
    public boolean isCreated() {
        return status.equals("CREATED");
    }

    @JsonIgnore
    public boolean isUpdated() {
        return status.equals("OK");
    }

    public String toJson() {
        return JsonUtils.writeObjectAsString(this);
    }
}
