/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security;

import org.easysearch.client.Validatable;

import java.util.Objects;

/**
 * Abstract request object to enable or disable a built-in or native user.
 */
public abstract class SetUserEnabledRequest implements Validatable {

    private final boolean enabled;
    private final String username;
    private final RefreshPolicy refreshPolicy;

    SetUserEnabledRequest(boolean enabled, String username, RefreshPolicy refreshPolicy) {
        this.enabled = enabled;
        this.username = Objects.requireNonNull(username, "username is required");
        this.refreshPolicy = refreshPolicy == null ? RefreshPolicy.getDefault() : refreshPolicy;
    }

    public boolean isEnabled() {
        return enabled;
    }

    public String getUsername() {
        return username;
    }

    public RefreshPolicy getRefreshPolicy() {
        return refreshPolicy;
    }
}
