/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.support.expressiondsl.expressions;

import org.easysearch.client.security.support.expressiondsl.RoleMapperExpression;

import java.util.ArrayList;
import java.util.List;

/**
 * An expression that evaluates to <code>true</code> if-and-only-if all its children
 * evaluate to <code>true</code>.
 * An <em>all</em> expression with no children is always <code>true</code>.
 */
public final class AllRoleMapperExpression extends CompositeRoleMapperExpression {

    private AllRoleMapperExpression(String name, RoleMapperExpression[] elements) {
        super(name, elements);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<RoleMapperExpression> elements = new ArrayList<>();

        public Builder addExpression(final RoleMapperExpression expression) {
            assert expression != null : "expression cannot be null";
            elements.add(expression);
            return this;
        }

        public AllRoleMapperExpression build() {
            return new AllRoleMapperExpression(CompositeType.ALL.getName(), elements.toArray(new RoleMapperExpression[0]));
        }
    }
}
