/* Copyright © INFINI Ltd. All rights reserved.
 * Web: https://infinilabs.com
 * Email: hello#infini.ltd */

package org.easysearch.client.security.support.expressiondsl.expressions;

import org.easysearch.common.ParseField;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum CompositeType {

    ANY("any"), ALL("all"), EXCEPT("except");

    private static Map<String, CompositeType> nameToType = Collections.unmodifiableMap(initialize());
    private ParseField field;

    CompositeType(String name) {
        this.field = new ParseField(name);
    }

    public String getName() {
        return field.getPreferredName();
    }

    public ParseField getParseField() {
        return field;
    }

    public static CompositeType fromName(String name) {
        return nameToType.get(name);
    }

    private static Map<String, CompositeType> initialize() {
        Map<String, CompositeType> map = new HashMap<>();
        for (CompositeType field : values()) {
            map.put(field.getName(), field);
        }
        return map;
    }

}
